/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.wvtool.config;

import edu.udo.cs.wvtool.config.WVTConfigurationFact;
import edu.udo.cs.wvtool.config.WVTConfigurationRule;
import edu.udo.cs.wvtool.generic.charmapper.DummyCharConverter;
import edu.udo.cs.wvtool.generic.inputfilter.SelectingInputFilter;
import edu.udo.cs.wvtool.generic.loader.UniversalLoader;
import edu.udo.cs.wvtool.generic.stemmer.LovinsStemmerWrapper;
import edu.udo.cs.wvtool.generic.tokenizer.SimpleTokenizer;
import edu.udo.cs.wvtool.generic.vectorcreation.TFIDF;
import edu.udo.cs.wvtool.generic.wordfilter.StopWordsWrapper;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import edu.udo.cs.wvtool.util.WVToolLogger;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class WVTConfiguration {
    public static final String STEP_INPUT_FILTER = "inputfilter";
    public static final String STEP_CHAR_MAPPER = "charmapper";
    public static final String STEP_LOADER = "loader";
    public static final String STEP_TOKENIZER = "tokenizer";
    public static final String STEP_WORDFILTER = "wordfilter";
    public static final String STEP_STEMMER = "stemmer";
    public static final String STEP_VECTOR_CREATION = "vectorcreation";
    public static final String STEP_OUTPUT = "output";
    public static final int TYPE_TEXT = 0;
    public static final int TYPE_XML = 1;
    public static final int TYPE_HTML = 2;
    public static final int TYPE_PDF = 3;
    private Map ruleSet = null;

    public WVTConfiguration(Reader reader) {
    }

    public WVTConfiguration() {
        this.ruleSet = new HashMap();
        this.setConfigurationRule(STEP_INPUT_FILTER, new WVTConfigurationFact(new SelectingInputFilter()));
        this.setConfigurationRule(STEP_LOADER, new WVTConfigurationFact(new UniversalLoader()));
        this.setConfigurationRule(STEP_CHAR_MAPPER, new WVTConfigurationFact(new DummyCharConverter()));
        this.setConfigurationRule(STEP_TOKENIZER, new WVTConfigurationFact(new SimpleTokenizer()));
        this.setConfigurationRule(STEP_WORDFILTER, new WVTConfigurationFact(new StopWordsWrapper()));
        this.setConfigurationRule(STEP_STEMMER, new WVTConfigurationFact(new LovinsStemmerWrapper()));
        this.setConfigurationRule(STEP_VECTOR_CREATION, new WVTConfigurationFact(new TFIDF()));
        this.setConfigurationRule(STEP_OUTPUT, new WVTConfigurationFact(null));
    }

    public final void setConfigurationRule(String string, WVTConfigurationRule wVTConfigurationRule) {
        this.ruleSet.put(string, wVTConfigurationRule);
    }

    public final Object getComponentForStep(String string, WVTDocumentInfo wVTDocumentInfo) {
        try {
            WVTConfigurationRule wVTConfigurationRule = (WVTConfigurationRule)this.ruleSet.get(string);
            if (wVTConfigurationRule == null) {
                return null;
            }
            return wVTConfigurationRule.getMatchingComponent(wVTDocumentInfo);
        }
        catch (Exception exception) {
            WVToolLogger.getGlobalLogger().logException("Could not initialize step.", exception);
            return null;
        }
    }

    public static int determineType(WVTDocumentInfo wVTDocumentInfo) {
        String string;
        int n;
        String string2 = wVTDocumentInfo.getContentType();
        if (string2.length() == 0 && (n = (string = wVTDocumentInfo.getSourceName()).lastIndexOf(46)) >= 0) {
            string2 = string.substring(n + 1);
        }
        if (string2.equalsIgnoreCase("htm")) {
            string2 = "html";
        }
        if (string2.equalsIgnoreCase("pdf")) {
            return 3;
        }
        if (string2.equalsIgnoreCase("html")) {
            return 2;
        }
        if (string2.equalsIgnoreCase("xml")) {
            return 1;
        }
        return 0;
    }
}

