/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.wvtool.external;

public class GermanStemmer {
    private StringBuffer sb = new StringBuffer();
    private int substCount = 0;

    public String stem(String string) {
        if (!this.isStemmable(string = string.toLowerCase())) {
            return string;
        }
        this.sb.delete(0, this.sb.length());
        this.sb.insert(0, string);
        this.substitute(this.sb);
        this.strip(this.sb);
        this.optimize(this.sb);
        this.resubstitute(this.sb);
        this.removeParticleDenotion(this.sb);
        return this.sb.toString();
    }

    private boolean isStemmable(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetter(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void strip(StringBuffer stringBuffer) {
        boolean bl = true;
        while (bl && stringBuffer.length() > 3) {
            if (stringBuffer.length() + this.substCount > 5 && stringBuffer.substring(stringBuffer.length() - 2, stringBuffer.length()).equals("nd")) {
                stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
                continue;
            }
            if (stringBuffer.length() + this.substCount > 4 && stringBuffer.substring(stringBuffer.length() - 2, stringBuffer.length()).equals("em")) {
                stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
                continue;
            }
            if (stringBuffer.length() + this.substCount > 4 && stringBuffer.substring(stringBuffer.length() - 2, stringBuffer.length()).equals("er")) {
                stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
                continue;
            }
            if (stringBuffer.charAt(stringBuffer.length() - 1) == 'e') {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                continue;
            }
            if (stringBuffer.charAt(stringBuffer.length() - 1) == 's') {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                continue;
            }
            if (stringBuffer.charAt(stringBuffer.length() - 1) == 'n') {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                continue;
            }
            if (stringBuffer.charAt(stringBuffer.length() - 1) == 't') {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                continue;
            }
            bl = false;
        }
    }

    private void optimize(StringBuffer stringBuffer) {
        if (stringBuffer.length() > 5 && stringBuffer.substring(stringBuffer.length() - 5, stringBuffer.length()).equals("erin*")) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            this.strip(stringBuffer);
        }
        if (stringBuffer.charAt(stringBuffer.length() - 1) == 'z') {
            stringBuffer.setCharAt(stringBuffer.length() - 1, 'x');
        }
    }

    private void removeParticleDenotion(StringBuffer stringBuffer) {
        if (stringBuffer.length() > 4) {
            for (int i = 0; i < stringBuffer.length() - 3; ++i) {
                if (!stringBuffer.substring(i, i + 4).equals("gege")) continue;
                stringBuffer.delete(i, i + 2);
                return;
            }
        }
    }

    private void substitute(StringBuffer stringBuffer) {
        this.substCount = 0;
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (i > 0 && stringBuffer.charAt(i) == stringBuffer.charAt(i - 1)) {
                stringBuffer.setCharAt(i, '*');
            } else if (stringBuffer.charAt(i) == '\u00e4') {
                stringBuffer.setCharAt(i, 'a');
            } else if (stringBuffer.charAt(i) == '\u00f6') {
                stringBuffer.setCharAt(i, 'o');
            } else if (stringBuffer.charAt(i) == '\u00fc') {
                stringBuffer.setCharAt(i, 'u');
            }
            if (i >= stringBuffer.length() - 1) continue;
            if (stringBuffer.charAt(i) == '\u00df') {
                stringBuffer.setCharAt(i, 's');
                stringBuffer.insert(i + 1, 's');
                ++this.substCount;
                continue;
            }
            if (i < stringBuffer.length() - 2 && stringBuffer.charAt(i) == 's' && stringBuffer.charAt(i + 1) == 'c' && stringBuffer.charAt(i + 2) == 'h') {
                stringBuffer.setCharAt(i, '$');
                stringBuffer.delete(i + 1, i + 3);
                this.substCount = 2;
                continue;
            }
            if (stringBuffer.charAt(i) == 'c' && stringBuffer.charAt(i + 1) == 'h') {
                stringBuffer.setCharAt(i, '\u00a7');
                stringBuffer.deleteCharAt(i + 1);
                ++this.substCount;
                continue;
            }
            if (stringBuffer.charAt(i) == 'e' && stringBuffer.charAt(i + 1) == 'i') {
                stringBuffer.setCharAt(i, '%');
                stringBuffer.deleteCharAt(i + 1);
                ++this.substCount;
                continue;
            }
            if (stringBuffer.charAt(i) == 'i' && stringBuffer.charAt(i + 1) == 'e') {
                stringBuffer.setCharAt(i, '&');
                stringBuffer.deleteCharAt(i + 1);
                ++this.substCount;
                continue;
            }
            if (stringBuffer.charAt(i) == 'i' && stringBuffer.charAt(i + 1) == 'g') {
                stringBuffer.setCharAt(i, '#');
                stringBuffer.deleteCharAt(i + 1);
                ++this.substCount;
                continue;
            }
            if (stringBuffer.charAt(i) != 's' || stringBuffer.charAt(i + 1) != 't') continue;
            stringBuffer.setCharAt(i, '!');
            stringBuffer.deleteCharAt(i + 1);
            ++this.substCount;
        }
    }

    private void resubstitute(StringBuffer stringBuffer) {
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) == '*') {
                char c = stringBuffer.charAt(i - 1);
                stringBuffer.setCharAt(i, c);
                continue;
            }
            if (stringBuffer.charAt(i) == '$') {
                stringBuffer.setCharAt(i, 's');
                stringBuffer.insert(i + 1, new char[]{'c', 'h'}, 0, 2);
                continue;
            }
            if (stringBuffer.charAt(i) == '\u00a7') {
                stringBuffer.setCharAt(i, 'c');
                stringBuffer.insert(i + 1, 'h');
                continue;
            }
            if (stringBuffer.charAt(i) == '%') {
                stringBuffer.setCharAt(i, 'e');
                stringBuffer.insert(i + 1, 'i');
                continue;
            }
            if (stringBuffer.charAt(i) == '&') {
                stringBuffer.setCharAt(i, 'i');
                stringBuffer.insert(i + 1, 'e');
                continue;
            }
            if (stringBuffer.charAt(i) == '#') {
                stringBuffer.setCharAt(i, 'i');
                stringBuffer.insert(i + 1, 'g');
                continue;
            }
            if (stringBuffer.charAt(i) != '!') continue;
            stringBuffer.setCharAt(i, 's');
            stringBuffer.insert(i + 1, 't');
        }
    }
}

