/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.wvtool.external;

import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;

public class XmlReader {
    public static final int START_DOCUMENT = 0;
    public static final int END_DOCUMENT = 1;
    public static final int START_TAG = 2;
    public static final int END_TAG = 3;
    public static final int TEXT = 4;
    public static final int CDSECT = 5;
    static final int ENTITY_REF = 6;
    private static final String UNEXPECTED_EOF = "Unexpected EOF";
    private static final int LEGACY = 999;
    public boolean relaxed;
    private Hashtable entityMap;
    private int depth;
    private String[] elementStack = new String[4];
    private Reader reader;
    private char[] srcBuf = new char[Runtime.getRuntime().freeMemory() >= 0x100000L ? 8192 : 128];
    private int srcPos;
    private int srcCount;
    private boolean eof;
    private int line;
    private int column;
    private int peek0;
    private int peek1;
    private char[] txtBuf = new char[128];
    private int txtPos;
    private int type;
    private String text;
    private boolean isWhitespace;
    private String name;
    private boolean degenerated;
    private int attributeCount;
    private String[] attributes = new String[16];
    private String[] TYPES = new String[]{"Start Document", "End Document", "Start Tag", "End Tag", "Text"};

    private final int read() throws IOException {
        int n = this.peek0;
        this.peek0 = this.peek1;
        if (this.peek0 == -1) {
            this.eof = true;
            return n;
        }
        if (n == 10 || n == 13) {
            ++this.line;
            this.column = 0;
            if (n == 13 && this.peek0 == 10) {
                this.peek0 = 0;
            }
        }
        ++this.column;
        if (this.srcPos >= this.srcCount) {
            this.srcCount = this.reader.read(this.srcBuf, 0, this.srcBuf.length);
            if (this.srcCount <= 0) {
                this.peek1 = -1;
                return n;
            }
            this.srcPos = 0;
        }
        this.peek1 = this.srcBuf[this.srcPos++];
        return n;
    }

    private final void exception(String string) throws IOException {
        throw new IOException(string + " pos: " + this.getPositionDescription());
    }

    private final void push(int n) {
        if (n == 0) {
            return;
        }
        if (this.txtPos == this.txtBuf.length) {
            char[] cArray = new char[this.txtPos * 4 / 3 + 4];
            System.arraycopy(this.txtBuf, 0, cArray, 0, this.txtPos);
            this.txtBuf = cArray;
        }
        this.txtBuf[this.txtPos++] = (char)n;
    }

    private final void read(char c) throws IOException {
        if (this.read() != c) {
            if (this.relaxed) {
                if (c <= ' ') {
                    this.skip();
                    this.read();
                }
            } else {
                this.exception("expected: '" + c + "'");
            }
        }
    }

    private final void skip() throws IOException {
        while (!this.eof && this.peek0 <= 32) {
            this.read();
        }
    }

    private final String pop(int n) {
        String string = new String(this.txtBuf, n, this.txtPos - n);
        this.txtPos = n;
        return string;
    }

    private final String readName() throws IOException {
        int n = this.txtPos;
        int n2 = this.peek0;
        if (!(n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90 || n2 == 95 || n2 == 58 || this.relaxed)) {
            this.exception("name expected");
        }
        do {
            this.push(this.read());
        } while ((n2 = this.peek0) >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90 || n2 >= 48 && n2 <= 57 || n2 == 95 || n2 == 45 || n2 == 58 || n2 == 46);
        return this.pop(n);
    }

    private final void parseLegacy(boolean bl) throws IOException {
        int n;
        String string = "";
        this.read();
        int n2 = this.read();
        if (n2 == 63) {
            n = 63;
        } else if (n2 == 33) {
            if (this.peek0 == 45) {
                string = "--";
                n = 45;
            } else {
                string = "DOCTYPE";
                n = -1;
            }
        } else {
            if (n2 != 91) {
                this.exception("cantreachme: " + n2);
            }
            string = "CDATA[";
            n = 93;
        }
        for (int i = 0; i < string.length(); ++i) {
            this.read(string.charAt(i));
        }
        if (n == -1) {
            this.parseDoctype();
        } else {
            do {
                if (this.eof) {
                    this.exception(UNEXPECTED_EOF);
                }
                n2 = this.read();
                if (!bl) continue;
                this.push(n2);
            } while (n != 63 && n2 != n || this.peek0 != n || this.peek1 != 62);
            this.read();
            this.read();
            if (bl && n != 63) {
                this.pop(this.txtPos - 1);
            }
        }
    }

    private final void parseDoctype() throws IOException {
        int n = 1;
        while (true) {
            int n2 = this.read();
            switch (n2) {
                case -1: {
                    this.exception(UNEXPECTED_EOF);
                }
                case 60: {
                    ++n;
                    break;
                }
                case 62: {
                    if (--n != 0) break;
                    return;
                }
            }
        }
    }

    private final void parseEndTag() throws IOException {
        this.read();
        this.read();
        this.name = this.readName();
        if (this.depth == 0 && !this.relaxed) {
            this.exception("element stack empty");
        }
        if (this.name.equals(this.elementStack[this.depth - 1])) {
            --this.depth;
        } else if (!this.relaxed) {
            this.exception("expected: " + this.elementStack[this.depth]);
        }
        this.skip();
        this.read('>');
    }

    private final int peekType() {
        switch (this.peek0) {
            case -1: {
                return 1;
            }
            case 38: {
                return 6;
            }
            case 60: {
                switch (this.peek1) {
                    case 47: {
                        return 3;
                    }
                    case 91: {
                        return 5;
                    }
                    case 33: 
                    case 63: {
                        return 999;
                    }
                }
                return 2;
            }
        }
        return 4;
    }

    private static final String[] ensureCapacity(String[] stringArray, int n) {
        if (stringArray.length >= n) {
            return stringArray;
        }
        String[] stringArray2 = new String[n + 16];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    private final void parseStartTag() throws IOException {
        this.read();
        this.name = this.readName();
        this.elementStack = XmlReader.ensureCapacity(this.elementStack, this.depth + 1);
        this.elementStack[this.depth++] = this.name;
        while (true) {
            String string;
            this.skip();
            int n = this.peek0;
            if (n == 47) {
                this.degenerated = true;
                this.read();
                this.skip();
                this.read('>');
                break;
            }
            if (n == 62) {
                this.read();
                break;
            }
            if (n == -1) {
                this.exception(UNEXPECTED_EOF);
            }
            if ((string = this.readName()).length() == 0) {
                this.exception("attr name expected");
            }
            this.skip();
            this.read('=');
            this.skip();
            int n2 = this.read();
            if (n2 != 39 && n2 != 34) {
                if (!this.relaxed) {
                    this.exception("<" + this.name + ">: invalid delimiter: " + (char)n2);
                }
                n2 = 32;
            }
            int n3 = this.attributeCount++ << 1;
            this.attributes = XmlReader.ensureCapacity(this.attributes, n3 + 4);
            this.attributes[n3++] = string;
            int n4 = this.txtPos;
            this.pushText(n2);
            this.attributes[n3] = this.pop(n4);
            if (n2 == 32) continue;
            this.read();
        }
    }

    public final boolean pushEntity() throws IOException {
        this.read();
        int n = this.txtPos;
        while (!this.eof && this.peek0 != 59) {
            this.push(this.read());
        }
        String string = this.pop(n);
        this.read();
        if (string.length() > 0 && string.charAt(0) == '#') {
            int n2 = string.charAt(1) == 'x' ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string.substring(1));
            this.push(n2);
            return n2 <= 32;
        }
        String string2 = (String)this.entityMap.get(string);
        boolean bl = true;
        if (string2 == null) {
            string2 = "&" + string + ";";
        }
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c > ' ') {
                bl = false;
            }
            this.push(c);
        }
        return bl;
    }

    private final boolean pushText(int n) throws IOException {
        boolean bl = true;
        int n2 = this.peek0;
        while (!this.eof && n2 != n && (n != 32 || n2 > 32 && n2 != 62)) {
            if (n2 == 38) {
                if (!this.pushEntity()) {
                    bl = false;
                }
            } else {
                if (n2 > 32) {
                    bl = false;
                }
                this.push(this.read());
            }
            n2 = this.peek0;
        }
        return bl;
    }

    public XmlReader(Reader reader) throws IOException {
        this.reader = reader;
        this.peek0 = reader.read();
        this.peek1 = reader.read();
        this.eof = this.peek0 == -1;
        this.entityMap = new Hashtable();
        this.entityMap.put("amp", "&");
        this.entityMap.put("apos", "'");
        this.entityMap.put("gt", ">");
        this.entityMap.put("lt", "<");
        this.entityMap.put("quot", "\"");
        this.line = 1;
        this.column = 1;
    }

    public void defineCharacterEntity(String string, String string2) {
        this.entityMap.put(string, string2);
    }

    public int getDepth() {
        return this.depth;
    }

    public String getPositionDescription() {
        StringBuffer stringBuffer = new StringBuffer(this.type < this.TYPES.length ? this.TYPES[this.type] : "Other");
        stringBuffer.append(" @" + this.line + ":" + this.column + ": ");
        if (this.type == 2 || this.type == 3) {
            stringBuffer.append('<');
            if (this.type == 3) {
                stringBuffer.append('/');
            }
            stringBuffer.append(this.name);
            stringBuffer.append('>');
        } else if (this.isWhitespace) {
            stringBuffer.append("[whitespace]");
        } else {
            stringBuffer.append(this.getText());
        }
        return stringBuffer.toString();
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public boolean isWhitespace() {
        return this.isWhitespace;
    }

    public String getText() {
        if (this.text == null) {
            this.text = this.pop(0);
        }
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEmptyElementTag() {
        return this.degenerated;
    }

    public int getAttributeCount() {
        return this.attributeCount;
    }

    public String getAttributeName(int n) {
        if (n >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[n << 1];
    }

    public String getAttributeValue(int n) {
        if (n >= this.attributeCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.attributes[(n << 1) + 1];
    }

    public String getAttributeValue(String string) {
        for (int i = (this.attributeCount << 1) - 2; i >= 0; i -= 2) {
            if (!this.attributes[i].equals(string)) continue;
            return this.attributes[i + 1];
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public int next() throws IOException {
        if (this.degenerated) {
            this.type = 3;
            this.degenerated = false;
            --this.depth;
            return this.type;
        }
        this.txtPos = 0;
        this.isWhitespace = true;
        do {
            this.attributeCount = 0;
            this.name = null;
            this.text = null;
            this.type = this.peekType();
            switch (this.type) {
                case 6: {
                    this.isWhitespace &= this.pushEntity();
                    this.type = 4;
                    break;
                }
                case 2: {
                    this.parseStartTag();
                    break;
                }
                case 3: {
                    this.parseEndTag();
                    break;
                }
                case 1: {
                    break;
                }
                case 4: {
                    this.isWhitespace &= this.pushText(60);
                    break;
                }
                case 5: {
                    this.parseLegacy(true);
                    this.isWhitespace = false;
                    this.type = 4;
                    break;
                }
                default: {
                    this.parseLegacy(false);
                }
            }
        } while (this.type > 4 || this.type == 4 && this.peekType() >= 4);
        this.isWhitespace &= this.type == 4;
        return this.type;
    }

    public void require(int n, String string) throws IOException {
        if (this.type == 4 && n != 4 && this.isWhitespace()) {
            this.next();
        }
        if (n != this.type || string != null && !string.equals(this.getName())) {
            this.exception("expected: " + this.TYPES[n] + "/" + string);
        }
    }

    public String readText() throws IOException {
        if (this.type != 4) {
            return "";
        }
        String string = this.getText();
        this.next();
        return string;
    }
}

