/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.wvtool.generic.inputfilter;

import edu.udo.cs.wvtool.config.WVTConfiguration;
import edu.udo.cs.wvtool.generic.inputfilter.PDFInputFilter;
import edu.udo.cs.wvtool.generic.inputfilter.SimpleTagIgnoringReader;
import edu.udo.cs.wvtool.generic.inputfilter.TextInputFilter;
import edu.udo.cs.wvtool.generic.inputfilter.WVTInputFilter;
import edu.udo.cs.wvtool.generic.inputfilter.XMLInputFilter;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import edu.udo.cs.wvtool.util.WVToolException;
import java.io.InputStream;
import java.io.Reader;

public class SelectingInputFilter
implements WVTInputFilter {
    private WVTInputFilter pdfFilter = null;
    private WVTInputFilter textFilter = null;
    private WVTInputFilter xmlFilter = null;
    private WVTInputFilter htmlFilter = null;

    public Reader convertToPlainText(InputStream inputStream, WVTDocumentInfo wVTDocumentInfo) throws WVToolException {
        int n = WVTConfiguration.determineType(wVTDocumentInfo);
        switch (n) {
            case 3: {
                if (this.pdfFilter == null) {
                    this.pdfFilter = new PDFInputFilter();
                }
                return this.pdfFilter.convertToPlainText(inputStream, wVTDocumentInfo);
            }
            case 1: {
                if (this.xmlFilter == null) {
                    this.xmlFilter = new XMLInputFilter();
                }
                return this.xmlFilter.convertToPlainText(inputStream, wVTDocumentInfo);
            }
            case 2: {
                if (this.htmlFilter == null) {
                    this.htmlFilter = new SimpleTagIgnoringReader();
                }
                return this.htmlFilter.convertToPlainText(inputStream, wVTDocumentInfo);
            }
        }
        if (this.textFilter == null) {
            this.textFilter = new TextInputFilter();
        }
        return this.textFilter.convertToPlainText(inputStream, wVTDocumentInfo);
    }
}

