/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.wvtool.generic.output;

import edu.udo.cs.wvtool.generic.output.WVTOutputFilter;
import edu.udo.cs.wvtool.main.WVTWordVector;
import java.io.BufferedWriter;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;

public class WordVectorWriter
implements WVTOutputFilter {
    private final PrintWriter out;
    private final boolean sparse;
    private final boolean idAsAttribute;
    private final boolean useLabel;
    private int offset = 0;

    public WordVectorWriter(Writer writer, boolean bl) {
        this(writer, bl, false, false, 0);
    }

    public WordVectorWriter(Writer writer, boolean bl, boolean bl2, boolean bl3, int n) {
        this.idAsAttribute = bl2;
        this.out = new PrintWriter(new BufferedWriter(writer));
        this.sparse = bl;
        this.useLabel = bl3;
        this.offset = n;
    }

    public void write(WVTWordVector wVTWordVector) {
        int n = wVTWordVector.getDocumentInfo().getSourceName().lastIndexOf(File.separator);
        String string = n > 0 ? wVTWordVector.getDocumentInfo().getSourceName().substring(n + 1) : wVTWordVector.getDocumentInfo().getSourceName();
        int n2 = wVTWordVector.getDocumentInfo().getClassValue();
        if (this.out != null) {
            double[] dArray = wVTWordVector.getValues();
            if (!this.idAsAttribute) {
                this.out.print(string + ";");
            } else if (this.sparse) {
                this.out.print("id:" + string);
            } else {
                this.out.print(string);
            }
            for (int i = 0; i < dArray.length; ++i) {
                if (this.sparse) {
                    if (!(dArray[i] > 0.0)) continue;
                    this.out.print(" " + (i + this.offset) + ":" + dArray[i]);
                    continue;
                }
                this.out.print(" " + dArray[i]);
            }
            if (this.useLabel) {
                this.out.print(" " + n2);
            }
            this.out.println();
        }
    }

    public void close() {
        this.out.close();
    }
}

