/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.wvtool.generic.stemmer;

import edu.udo.cs.wvtool.generic.stemmer.AbstractStemmer;
import edu.udo.cs.wvtool.generic.stemmer.LovinsStemmerWrapper;
import edu.udo.cs.wvtool.generic.stemmer.SimpleStemmer;
import edu.udo.cs.wvtool.util.WVToolException;
import edu.udo.cs.wvtool.util.WVToolLogger;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.IndexWordSet;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.Dictionary;

public abstract class AbstractWordNetStemmer
extends AbstractStemmer {
    private final Dictionary dictionary;
    private final SimpleStemmer stemmer;
    private final int maxSenses;

    public AbstractWordNetStemmer(SimpleStemmer simpleStemmer, int n) {
        this.maxSenses = n;
        this.stemmer = simpleStemmer;
        if (!JWNL.isInitialized()) {
            String string = System.getProperty("wvtool.wnconfig");
            try {
                JWNL.initialize((InputStream)new FileInputStream(string));
            }
            catch (FileNotFoundException fileNotFoundException) {
                WVToolLogger.getGlobalLogger().logException("Could not read JWNL configuration file.", fileNotFoundException);
            }
            catch (JWNLException jWNLException) {
                WVToolLogger.getGlobalLogger().logException("Could not initialize JWNL.", (Exception)((Object)jWNLException));
            }
        }
        this.dictionary = Dictionary.getInstance();
    }

    public AbstractWordNetStemmer() {
        this(new LovinsStemmerWrapper(), 1);
    }

    protected IndexWord getIndexWord(String string) throws JWNLException, WVToolException {
        IndexWordSet indexWordSet;
        IndexWord indexWord = null;
        POS[] pOSArray = new POS[]{POS.NOUN, POS.ADJECTIVE, POS.VERB, POS.ADVERB};
        IndexWordSet indexWordSet2 = this.dictionary.lookupAllIndexWords(string);
        if (indexWordSet2 != null) {
            for (int i = 0; i < pOSArray.length && indexWord == null; ++i) {
                indexWord = indexWordSet2.getIndexWord(pOSArray[i]);
            }
        }
        if (indexWord == null && this.stemmer != null && (indexWordSet = this.dictionary.lookupAllIndexWords(this.stemmer.getBase(string))) != null) {
            for (int i = 0; i < pOSArray.length && indexWord == null; ++i) {
                indexWord = indexWordSet.getIndexWord(pOSArray[i]);
            }
        }
        return indexWord;
    }

    protected abstract String getWordForm(IndexWord var1) throws JWNLException;

    public String getBase(String string) throws WVToolException {
        String string2 = null;
        try {
            IndexWord indexWord = this.getIndexWord(string);
            string2 = indexWord != null ? (indexWord.getSenseCount() <= this.maxSenses ? this.getWordForm(indexWord) : indexWord.getLemma()) : string;
        }
        catch (JWNLException jWNLException) {
            string2 = string;
        }
        return string2;
    }
}

