/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.wvtool.generic.stemmer;

import edu.udo.cs.wvtool.generic.stemmer.AbstractStemmer;
import edu.udo.cs.wvtool.generic.stemmer.SimpleStemmer;
import edu.udo.cs.wvtool.util.WVToolException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DictionaryStemmer
extends AbstractStemmer {
    private final Map termMap = new HashMap();
    private final Map regExprList = new LinkedHashMap();
    private final Map additionalMap = new HashMap();
    private final boolean addMappings;
    private final SimpleStemmer fallBackStemmer;

    public DictionaryStemmer() {
        this.fallBackStemmer = null;
        this.addMappings = false;
    }

    public DictionaryStemmer(Reader reader) throws IOException {
        this(reader, null, false);
    }

    public DictionaryStemmer(Reader reader, SimpleStemmer simpleStemmer, boolean bl) throws IOException {
        this.addMappings = bl;
        this.fallBackStemmer = simpleStemmer;
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ": ");
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string2 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!this.containsLettersOnly(string3)) {
                    this.addRegularExpression(string3, string2);
                    continue;
                }
                this.termMap.put(string3, string2);
            }
        }
        bufferedReader.close();
    }

    private boolean containsLettersOnly(String string) {
        boolean bl = true;
        for (int i = 0; i < string.length() && bl; ++i) {
            if (Character.isLetter(string.charAt(i))) continue;
            bl = false;
        }
        return bl;
    }

    public String getBase(String string) throws WVToolException {
        String string2 = string.toLowerCase();
        String string3 = (String)this.termMap.get(string2);
        if (string3 != null) {
            return string3;
        }
        Iterator iterator = this.regExprList.keySet().iterator();
        while (iterator.hasNext() && string3 == null) {
            Pattern pattern = (Pattern)iterator.next();
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.matches()) continue;
            string3 = (String)this.regExprList.get(pattern);
        }
        if (string3 == null && this.fallBackStemmer != null && (string3 = this.fallBackStemmer.getBase(string2)) != null && this.addMappings) {
            this.additionalMap.put(string2, string3);
        }
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public void addTermMapping(String string, String string2) {
        if (this.termMap.get(string) == null) {
            this.termMap.put(string.toLowerCase(), string2.toLowerCase());
        }
    }

    public void addRegularExpression(String string, String string2) {
        Pattern pattern = Pattern.compile(string);
        this.regExprList.put(pattern, string2.toLowerCase());
    }

    public void writeAddedMappings(Writer writer) {
        LinkedList<Object> linkedList;
        PrintWriter printWriter = new PrintWriter(writer);
        Iterator iterator = this.additionalMap.keySet().iterator();
        HashMap<String, LinkedList<Object>> hashMap = new HashMap<String, LinkedList<Object>>();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.additionalMap.get(string);
            linkedList = (LinkedList<Object>)hashMap.get(string2);
            if (linkedList == null) {
                linkedList = new LinkedList<Object>();
                hashMap.put(string2, linkedList);
            }
            linkedList.add(string);
        }
        for (String string2 : hashMap.keySet()) {
            linkedList = (List)hashMap.get(string2);
            printWriter.print(string2 + ":");
            Iterator iterator2 = linkedList.iterator();
            while (iterator2.hasNext()) {
                printWriter.print(iterator2.next() + " ");
            }
            printWriter.println();
        }
        printWriter.close();
    }
}

