/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.wvtool.generic.stemmer;

import edu.udo.cs.wvtool.generic.stemmer.AbstractStemmer;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import edu.udo.cs.wvtool.util.TokenEnumeration;
import edu.udo.cs.wvtool.util.WVToolException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.tartarus.snowball.SnowballProgram;

public class SnowballStemmerWrapper
extends AbstractStemmer {
    private SnowballProgram stemmer;
    private Method stemMethod;
    private static final String DEFAULT_LANGUAGE = "english";

    public SnowballStemmerWrapper() throws WVToolException {
        this.setLanguage(DEFAULT_LANGUAGE);
    }

    public TokenEnumeration stem(TokenEnumeration tokenEnumeration, WVTDocumentInfo wVTDocumentInfo) throws WVToolException {
        super.stem(tokenEnumeration, wVTDocumentInfo);
        this.setLanguage(wVTDocumentInfo.getContentLanguage());
        return this;
    }

    private void setLanguage(String string) throws WVToolException {
        try {
            Class<?> clazz = Class.forName("org.tartarus.snowball.ext." + string + "Stemmer");
            this.stemmer = (SnowballProgram)clazz.newInstance();
            this.stemMethod = clazz.getMethod("stem", new Class[0]);
        }
        catch (Exception exception) {
            throw new WVToolException("Could not initialize the snowball stemmer for the specified language.", exception);
        }
    }

    public String getBase(String string) throws WVToolException {
        if (string != null) {
            String string2 = string.toLowerCase();
            this.stemmer.setCurrent(string2);
            try {
                this.stemMethod.invoke((Object)this.stemmer, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new WVToolException("Could not stem word " + string, illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new WVToolException("Could not stem word " + string, invocationTargetException);
            }
            return this.stemmer.getCurrent();
        }
        return null;
    }
}

