/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.wvtool.generic.stemmer;

import edu.udo.cs.wvtool.generic.stemmer.AbstractWordNetStemmer;
import edu.udo.cs.wvtool.generic.stemmer.SimpleStemmer;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.PointerUtils;
import net.didion.jwnl.data.list.PointerTargetNode;
import net.didion.jwnl.data.list.PointerTargetNodeList;

public class WordNetHypernymStemmer
extends AbstractWordNetStemmer {
    public WordNetHypernymStemmer() {
    }

    public WordNetHypernymStemmer(SimpleStemmer simpleStemmer, int n) {
        super(simpleStemmer, n);
    }

    protected String getWordForm(IndexWord indexWord) {
        if (indexWord.getSenseCount() == 1) {
            PointerTargetNodeList pointerTargetNodeList;
            try {
                pointerTargetNodeList = PointerUtils.getInstance().getDirectHypernyms(indexWord.getSense(1));
            }
            catch (Exception exception) {
                pointerTargetNodeList = null;
            }
            if (pointerTargetNodeList != null && pointerTargetNodeList.size() > 0) {
                return ((PointerTargetNode)pointerTargetNodeList.get(0)).getSynset().getWord(0).getLemma();
            }
            return indexWord.getLemma();
        }
        return indexWord.getLemma();
    }
}

