/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.wvtool.generic.tokenizer;

import edu.udo.cs.wvtool.generic.tokenizer.WVTTokenizer;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import edu.udo.cs.wvtool.util.TokenEnumeration;
import edu.udo.cs.wvtool.util.WVToolException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class NGramTokenizer
implements WVTTokenizer,
TokenEnumeration {
    private final List currentTokens;
    private final int n;
    private TokenEnumeration input;
    private final WVTTokenizer tokenizer;

    public NGramTokenizer(int n, WVTTokenizer wVTTokenizer) {
        this.n = n;
        this.tokenizer = wVTTokenizer;
        this.input = null;
        this.currentTokens = new ArrayList();
    }

    public TokenEnumeration tokenize(Reader reader, WVTDocumentInfo wVTDocumentInfo) throws WVToolException {
        if (reader != null) {
            this.input = this.tokenizer.tokenize(reader, wVTDocumentInfo);
            this.readNextToken();
            return this;
        }
        return null;
    }

    private void readNextToken() throws WVToolException {
        if (this.input.hasMoreTokens()) {
            String string = this.input.nextToken();
            if (string.length() > this.n) {
                for (int i = 0; i < string.length() - this.n + 1; ++i) {
                    String string2 = string.substring(i, i + this.n);
                    this.currentTokens.add(string2);
                }
            } else {
                this.currentTokens.add(string);
            }
        }
    }

    public boolean hasMoreTokens() {
        if (this.input != null) {
            return this.currentTokens.size() > 0;
        }
        return false;
    }

    public String nextToken() throws WVToolException {
        String string = null;
        if (this.currentTokens.size() > 0) {
            string = (String)this.currentTokens.get(0);
            this.currentTokens.remove(0);
            if (this.currentTokens.size() == 0) {
                this.readNextToken();
            }
        } else {
            string = null;
        }
        return string;
    }
}

