/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.wvtool.generic.wordfilter;

import edu.udo.cs.wvtool.generic.wordfilter.WVTWordFilter;
import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import edu.udo.cs.wvtool.util.TokenEnumeration;
import edu.udo.cs.wvtool.util.WVToolException;
import edu.udo.cs.wvtool.util.WVToolLogger;

public abstract class AbstractStopWordFilter
implements WVTWordFilter,
TokenEnumeration {
    private TokenEnumeration input;
    private String currentToken;
    private int minNumChars;
    private static final int DEFAULT_MIN_CHARS = 3;

    public AbstractStopWordFilter(int n) {
        this.minNumChars = n;
    }

    public AbstractStopWordFilter() {
        this(3);
    }

    public TokenEnumeration filter(TokenEnumeration tokenEnumeration, WVTDocumentInfo wVTDocumentInfo) throws WVToolException {
        if (tokenEnumeration != null) {
            this.input = tokenEnumeration;
            this.readNextValidToken();
            return this;
        }
        return null;
    }

    public boolean hasMoreTokens() {
        if (this.input != null) {
            return this.currentToken != null;
        }
        return false;
    }

    public String nextToken() {
        try {
            String string = null;
            if (this.currentToken != null) {
                string = this.currentToken;
                this.readNextValidToken();
            } else {
                string = null;
            }
            return string;
        }
        catch (Exception exception) {
            WVToolLogger.getGlobalLogger().logException("Could not read next token", exception);
            return null;
        }
    }

    private void readNextValidToken() {
        try {
            if (!this.input.hasMoreTokens()) {
                this.currentToken = null;
                return;
            }
            String string = this.input.nextToken();
            while (this.input.hasMoreTokens() && (this.isStopword(string) || string.length() < this.minNumChars)) {
                string = this.input.nextToken();
            }
            this.currentToken = !this.isStopword(string) && string.length() >= this.minNumChars ? string : null;
        }
        catch (Exception exception) {
            this.currentToken = null;
            WVToolLogger.getGlobalLogger().logException("Could not read from token stream.", exception);
        }
    }

    protected abstract boolean isStopword(String var1);

    public int getMinNumChars() {
        return this.minNumChars;
    }

    public void setMinNumChars(int n) {
        this.minNumChars = n;
    }
}

