/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.wvtool.wordlist;

class WVTWord {
    private final String word;
    private int[] classCount;
    private int documentCount;
    private int localCount;

    public WVTWord(String string, int n) {
        this.word = string;
        this.classCount = new int[n];
        for (int i = 0; i < n; ++i) {
            this.classCount[i] = 0;
        }
        this.localCount = 0;
        this.documentCount = 0;
    }

    public WVTWord(String string) {
        this.word = string;
        this.classCount = null;
        this.localCount = 0;
        this.documentCount = 0;
    }

    public void addOccurance() {
        ++this.localCount;
    }

    public void closeDocument(boolean bl) {
        if (this.localCount > 0) {
            if (!bl) {
                ++this.documentCount;
            }
            this.localCount = 0;
        }
    }

    public void closeDocument(int n, boolean bl) {
        if (this.localCount > 0 && !bl) {
            ++this.documentCount;
            if (this.classCount != null && n >= 0 && n < this.classCount.length) {
                int n2 = n;
                this.classCount[n2] = this.classCount[n2] + 1;
            }
            this.localCount = 0;
        } else {
            this.localCount = 0;
        }
    }

    public int getLocalFrequency() {
        return this.localCount;
    }

    public int getDocumentFrequency() {
        return this.documentCount;
    }

    public void setDocumentFrequency(int n) {
        this.documentCount = n;
    }

    public void setClassFrequency(int n, int n2) {
        if (n >= 0 && n < this.classCount.length) {
            this.classCount[n] = n2;
        }
    }

    public int getClassFrequency(int n) {
        if (this.classCount != null) {
            if (n >= 0 && n < this.classCount.length) {
                return this.classCount[n];
            }
            return 0;
        }
        return 0;
    }

    public String getWord() {
        return this.word;
    }
}

