/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.wvtool.wordlist;

import edu.udo.cs.wvtool.main.WVTDocumentInfo;
import edu.udo.cs.wvtool.util.WVToolLogger;
import edu.udo.cs.wvtool.wordlist.WVTWord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class WVTWordList {
    private Map wordMap = null;
    private List wordList = null;
    private int numClasses = 0;
    private boolean appendWords = true;
    private boolean updateOnlyCurrent = true;
    private int numDocuments = 0;
    private int numLocalTerms = 0;

    public WVTWordList(int n) {
        this.wordList = new ArrayList();
        this.wordMap = new HashMap();
        this.numClasses = n;
    }

    public WVTWordList(List list, int n) {
        this(n);
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            WVTWord wVTWord = null;
            wVTWord = n > 0 ? new WVTWord(string, n) : new WVTWord(string);
            this.wordMap.put(string, wVTWord);
            this.wordList.add(wVTWord);
        }
    }

    public WVTWordList(Reader reader) {
        try {
            this.wordList = new ArrayList();
            this.wordMap = new HashMap();
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.nextToken().equals("@number_of_documents")) {
                this.numDocuments = Integer.parseInt(stringTokenizer.nextToken());
            }
            string = bufferedReader.readLine();
            stringTokenizer = new StringTokenizer(string);
            this.numClasses = 0;
            if (stringTokenizer.nextToken().equals("@number_of_classes")) {
                this.numClasses = Integer.parseInt(stringTokenizer.nextToken());
            }
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string, ",");
                String string2 = stringTokenizer2.nextToken();
                WVTWord wVTWord = new WVTWord(string2, this.numClasses);
                this.wordList.add(wVTWord);
                this.wordMap.put(string2, wVTWord);
                if (!stringTokenizer2.hasMoreTokens()) continue;
                String string3 = stringTokenizer2.nextToken();
                wVTWord.setDocumentFrequency(Integer.parseInt(string3));
                for (int i = 0; i < this.numClasses; ++i) {
                    if (!stringTokenizer2.hasMoreTokens()) continue;
                    String string4 = stringTokenizer2.nextToken();
                    wVTWord.setClassFrequency(i, Integer.parseInt(string4));
                }
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            WVToolLogger.getGlobalLogger().logException("Could not read word list.", iOException);
        }
    }

    public void addWordOccurance(String string) {
        WVTWord wVTWord = (WVTWord)this.wordMap.get(string);
        if (wVTWord == null && this.appendWords) {
            wVTWord = this.numClasses > 0 ? new WVTWord(string, this.numClasses) : new WVTWord(string);
            this.wordMap.put(string, wVTWord);
            this.wordList.add(wVTWord);
        }
        if (wVTWord != null) {
            wVTWord.addOccurance();
        }
        ++this.numLocalTerms;
    }

    public void closeDocument(WVTDocumentInfo wVTDocumentInfo) {
        if (wVTDocumentInfo.hasClassValue()) {
            for (int i = 0; i < this.wordList.size(); ++i) {
                ((WVTWord)this.wordList.get(i)).closeDocument(wVTDocumentInfo.getClassValue(), this.updateOnlyCurrent);
            }
        } else {
            for (int i = 0; i < this.wordList.size(); ++i) {
                ((WVTWord)this.wordList.get(i)).closeDocument(this.updateOnlyCurrent);
            }
        }
        if (!this.updateOnlyCurrent) {
            ++this.numDocuments;
        }
        this.numLocalTerms = 0;
    }

    public int[] getFrequenciesForCurrentDocument() {
        int[] nArray = new int[this.wordList.size()];
        for (int i = 0; i < this.wordList.size(); ++i) {
            nArray[i] = ((WVTWord)this.wordList.get(i)).getLocalFrequency();
        }
        return nArray;
    }

    public int getTermCountForCurrentDocument() {
        return this.numLocalTerms;
    }

    public int[] getDocumentFrequencies() {
        int[] nArray = new int[this.wordList.size()];
        for (int i = 0; i < this.wordList.size(); ++i) {
            nArray[i] = ((WVTWord)this.wordList.get(i)).getDocumentFrequency();
        }
        return nArray;
    }

    public int[] getClassFrequencies(int n) {
        int[] nArray = new int[this.wordList.size()];
        for (int i = 0; i < this.wordList.size(); ++i) {
            nArray[i] = ((WVTWord)this.wordList.get(i)).getClassFrequency(n);
        }
        return nArray;
    }

    public void store(Writer writer) {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(writer));
        printWriter.println("@number_of_documents " + this.numDocuments);
        printWriter.println("@number_of_classes " + this.numClasses);
        for (int i = 0; i < this.wordList.size(); ++i) {
            WVTWord wVTWord = (WVTWord)this.wordList.get(i);
            printWriter.print(wVTWord.getWord() + "," + wVTWord.getDocumentFrequency());
            for (int j = 0; j < this.numClasses; ++j) {
                printWriter.print("," + wVTWord.getClassFrequency(j));
            }
            printWriter.println("");
        }
        printWriter.close();
    }

    public void storePlain(Writer writer) {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(writer));
        for (int i = 0; i < this.wordList.size(); ++i) {
            WVTWord wVTWord = (WVTWord)this.wordList.get(i);
            printWriter.println(wVTWord.getWord());
        }
        printWriter.close();
    }

    public boolean isAppendWords() {
        return this.appendWords;
    }

    public boolean isUpdateOnlyCurrent() {
        return this.updateOnlyCurrent;
    }

    public void setAppendWords(boolean bl) {
        this.appendWords = bl;
    }

    public void setUpdateOnlyCurrent(boolean bl) {
        this.updateOnlyCurrent = bl;
    }

    public int getNumDocuments() {
        return this.numDocuments;
    }

    public int getNumWords() {
        return this.wordList.size();
    }

    public void pruneByFrequency(int n, int n2) {
        for (WVTWord wVTWord : this.wordMap.values()) {
            if (wVTWord.getDocumentFrequency() >= n && wVTWord.getDocumentFrequency() <= n2) continue;
            this.wordList.remove(wVTWord);
        }
    }

    public int getFrequencyByRank(int n) {
        if (this.getNumWords() < n) {
            return 0;
        }
        int[] nArray = new int[this.getNumWords()];
        Iterator iterator = this.wordList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            WVTWord wVTWord = (WVTWord)iterator.next();
            nArray[n2] = wVTWord.getDocumentFrequency();
            ++n2;
        }
        Arrays.sort(nArray);
        return nArray[nArray.length - n];
    }

    public String getWord(int n) {
        return ((WVTWord)this.wordList.get(n)).getWord();
    }
}

