package org.recommender101.guiconfig;

import java.util.ArrayList;

import org.recommender101.eval.impl.Recommender101Impl;
import org.recommender101.gui.annotations.R101Setting.SettingsType;

public class OtherSettingsConfiguration {

	public InternalR101Setting[] normalSettings =
		{
		new InternalR101Setting(Recommender101Impl.PROP_EVALUATION_TYPE,
				"Evaluation Type",
				"The evaluation type",
				SettingsType.ARRAY,
				0,
				0,
				new String[]{"crossvalidation", "giventrainingtestsplit"},
				"crossvalidation",
				new ArrayList<String>()),
		new InternalR101Setting(Recommender101Impl.PROP_GLOBAL_MIN_RATING,
				"Minimum rating",
				"The minimal possible rating",
				SettingsType.INTEGER,
				0,
				Integer.MAX_VALUE,
				new String[]{},
				"0",
				new ArrayList<String>()),				
		new InternalR101Setting(Recommender101Impl.PROP_GLOBAL_MAX_RATING,
				"Maximum rating",
				"The maximal possible rating",
				SettingsType.INTEGER,
				0,
				Integer.MAX_VALUE,
				new String[]{},
				"5",
				new ArrayList<String>()),
		new InternalR101Setting(Recommender101Impl.PROP_GLOBAL_TOP_N,
				"Top N",
				"The global list length default",
				SettingsType.INTEGER,
				0,
				Integer.MAX_VALUE,
				new String[]{},
				"10",
				new ArrayList<String>()),
		new InternalR101Setting(Recommender101Impl.PROP_GLOBAL_NUM_OF_THREADS,
				"Number of Threads",
				"Recommended value: Number of CPU cores",
				SettingsType.INTEGER,
				1,
				Integer.MAX_VALUE,
				new String[]{},
				"4",
				new ArrayList<String>()),
		new InternalR101Setting("GlobalSettings.listMetricsRelevanceMinPercentageAboveAverage",
				"Min Percentage Above Average for Relevance",
				"Threshold for relevance for list metrics",
				SettingsType.INTEGER,
				0,
				Integer.MAX_VALUE,
				new String[]{},
				"0",
				new ArrayList<String>()),
		new InternalR101Setting(Recommender101Impl.PROP_GLOBAL_PREDICTION_RELEVANCE_MIN_RATING,
				"Rating relevance threshold",
				"Threshold for rating to be relevant for list metrics",
				SettingsType.INTEGER,
				Integer.MIN_VALUE,
				Integer.MAX_VALUE,
				new String[]{},
				"-1",
				new ArrayList<String>()),
		new InternalR101Setting(Recommender101Impl.PROP_GLOBAL_FILTER_NON_RELEVANT_ITEMS_FOR_RECOMMENDATION,
				"Filter non-relevant items",
				"Whether to filter non-relevant items for recommendation",
				SettingsType.BOOLEAN,
				Integer.MIN_VALUE,
				Integer.MAX_VALUE,
				new String[]{},
				"false",
				new ArrayList<String>()),
		new InternalR101Setting(Recommender101Impl.PROP_GLOBAL_GIVEN_N_CONFIGURATION,
				"Given-n configuration",
				"The given-n configuration string",
				SettingsType.TEXT,
				Integer.MIN_VALUE,
				Integer.MAX_VALUE,
				new String[]{},
				"",
				new ArrayList<String>()),					
		new InternalR101Setting("ExperimentTitle",
				"Experiment title",
				"Title for the experiment",
				SettingsType.TEXT,
				Integer.MIN_VALUE,
				Integer.MAX_VALUE,
				new String[]{},
				"Experiment results", // I took this default value from Recommender101Impl.java
				new ArrayList<String>()),
		new InternalR101Setting("CSVOutputPath",
				"CSV Output path",
				"CSV files are put there",
				SettingsType.TEXT,
				Integer.MIN_VALUE,
				Integer.MAX_VALUE,
				new String[]{},
				"/",
				new ArrayList<String>()),
		new InternalR101Setting("CSVOutputMode",
				"CSV Output mode",
				"Create new files or append",
				SettingsType.ARRAY,
				Integer.MIN_VALUE,
				Integer.MAX_VALUE,
				new String[]{"new","append"},
				"new",
				new ArrayList<String>())
		};
	
	public final static InternalR101Setting[] debugSettings =
		{};

		
}
